<?php 
// Display errors for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'db.php';

// Add the X-Content-Type-Options header
header('X-Content-Type-Options: nosniff');
header("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36");
header("Referer: https://asianload.info/");
header("Origin: https://asianload.info/");



if (isset($_GET['id'])) {
    $id = intval($_GET['id']); // Ensure ID is an integer

    // Prepare and execute the query to fetch title, subtitle, subtitle_lang, url, and intro_end_time
    $stmt = $conn->prepare("SELECT title, subtitle, subtitle_lang, url, intro_end_time FROM streams WHERE id = ?");
    
    // Check if the prepare() was successful
    if ($stmt === false) {
        die("Error preparing statement: " . htmlspecialchars($conn->error));
    }

    $stmt->bind_param("i", $id);
    if (!$stmt->execute()) {
        die("Execution failed: " . htmlspecialchars($stmt->error));
    }

    $stmt->bind_result($title, $subtitle, $subtitle_lang, $url, $intro_end_time); // Include intro_end_time

    if ($stmt->fetch()) {
        // Debug output to check fetched values
        //var_dump($title, $subtitle, $subtitle_lang, $url, $intro_end_time);
    } else {
        echo "Stream not found.";
        exit;
    }

    $stmt->close();
} else {
    echo "No stream ID provided.";
    exit;
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($title); ?> - Embed</title>
    <!--
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/vidstack/styles/defaults.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/vidstack/styles/community-skin/video.min.css" />
    -->
    <link rel="dns-prefetch" href="https://asianload.org">
     <link rel="dns-prefetch" href="https://mxtop3.com">
      <link rel="preconnect" href="https://asianload.org" crossorigin>
    <link rel="stylesheet" href="https://cdn.vidstack.io/player/theme.css" />
    <link rel="stylesheet" href="https://cdn.vidstack.io/player/video.css" />


    <?php if (!empty($url)): ?>
        <?php 
            // Extract domain from the $url variable
            $mediaDomain = parse_url($url, PHP_URL_HOST); 
        ?>
        <link rel="dns-prefetch" href="https://<?php echo $mediaDomain; ?>">
        <link rel="preconnect" href="https://<?php echo $mediaDomain; ?>" crossorigin>
    <?php endif; ?>

    <style>
        #skipIntroButton {
            display: none; /* Initially hidden */
            position: absolute; /* Positioned on the video */
            bottom: 100px; /* Adjust placement (e.g., bottom of the video) */
            right: 20px;
            background-color: rgba(0, 0, 0, 0.7); /* Semi-transparent black background */
            color: white; /* White text */
            border: none; /* No border */
            border-radius: 5px; /* Rounded corners */
            padding: 10px 15px; /* Padding for a better touch area */
            font-size: 16px; /* Font size */
            cursor: pointer; /* Pointer cursor on hover */
            transition: opacity 0.2s; /* Smooth transition for opacity */
            z-index: 1000; /* Ensure it's above other elements */
        }

        #skipIntroButton:hover {
            opacity: 0.9; /* Slightly reduce opacity on hover */
        }

        #skipIntroButton:focus {
            outline: none; /* Remove default outline on focus */
        }

        /* Fullscreen button adjustments for mobile */
        @media only screen and (max-width: 768px) {
            #skipIntroButton {
                position: fixed;
                bottom: 60px;
                right: 5px;
                font-size: 14px;
                padding: 8px 12px;
            }
        }
     
.alert-type {
    position: absolute;
    top: 49%;
    width: 90%;
    left: 0;
    right: 0;
    margin: auto;
    font-family: Arial;
    text-align: center;
    color: #FFFF00;
    background: #000000;
    padding: 5px;
    border-radius: 5px;
    z-index: 1;
}

    </style>
</head>
<body>

<?php
// Define the original base URLs and their corresponding CDN base replacements
$base_mappings = [
    'https://d6n1.c16.e2-2.dev/ofwshow' => 'https://ofwshow8.b-cdn.net', // Dec 11 expiration
    'https://d6n1.c16.e2-2.dev/bidyu' => 'https://amirahtv.b-cdn.net',  
    'https://dlcvn-my.sharepoint.com' => 'https://ofwshow3.b-cdn.net' 
];

// Function to check and replace the base URL if it matches any old base
function replace_base_url_if_needed($url, $base_mappings) {
    foreach ($base_mappings as $old_base => $cdn_base) {
        // Only replace if the URL starts with the old base
        if (strpos($url, $old_base) === 0) {
            return str_replace($old_base, $cdn_base, $url);
        }
    }
    return $url;  // Return the original URL if no match
}

// Replace base URLs if needed before applying htmlspecialchars
$video_url = replace_base_url_if_needed($url, $base_mappings);
$subtitle_url = !empty($subtitle) ? replace_base_url_if_needed($subtitle, $base_mappings) : '';
?>

<?php if (strpos($video_url, 'dsaqtqpt.pro') !== false) { ?>
  <p class="alert-type">Sorry, server streaming is in maintenance. Try again later.</p>
<?php } ?>



<script type="module"> 
  import { VidstackPlayer, VidstackPlayerLayout } from 'https://cdn.vidstack.io/player';

  const videoUrl = "<?php echo htmlspecialchars($video_url); ?>";
  const title = "<?php echo htmlspecialchars_decode($title); ?>";

  // Check if video URL contains "mxtop3.com"
const proxiedUrl = videoUrl.includes("mxtop3.com")
  ? `https://ofwshow.online/player/stream2.php?url=${encodeURIComponent(videoUrl)}`
  : videoUrl.includes(".sbs")
    ? `https://ofwshow.online/player/stream9.php?url=${encodeURIComponent(videoUrl)}`
    : videoUrl.includes("asianload")
      ? `https://ofwshow.online/player/stream7.php?url=${encodeURIComponent(videoUrl)}`
      : videoUrl.includes("streamsub.top")
      ? `https://ofwshow.online/player/stream6.php?url=${encodeURIComponent(videoUrl)}`
      : videoUrl;


  const player = await VidstackPlayer.create({
    target: "#target",
    title: title,
    src: proxiedUrl,
    layout: new VidstackPlayerLayout({
      // Add additional layout options if needed
      // thumbnails: 'https://files.vidstack.io/sprite-fight/thumbnails.vtt',
    }),
  });
</script>


<video id="target" storage="storage-key" load="eager" controls crossorigin="anonymous" autoplay 
  playsinline>
  <source src="..." type="" />
   <?php if (!empty($subtitle) && !empty($subtitle_lang)) : ?>
      <track
        src="<?php echo htmlspecialchars($subtitle_url); ?>"
        kind="subtitles"
        label="<?php echo htmlspecialchars(ucfirst($subtitle_lang)); ?>"
        srclang="<?php echo htmlspecialchars($subtitle_lang); ?>"
        default
        data-type="vtt"
      />
    <?php endif; ?>
</video>




<script>
document.addEventListener('DOMContentLoaded', () => {
    const mediaPlayer = document.querySelector('media-player');
    const introEndTime = <?php echo intval($intro_end_time); ?>; // Get intro_end_time
    console.log('DOM Content Loaded');
    console.log('Intro End Time (seconds):', introEndTime); // Debug output

    // Create and style Skip Intro Button
    const skipIntroButton = document.createElement('button');
    skipIntroButton.id = 'skipIntroButton';
    skipIntroButton.textContent = 'Skip Intro';
    document.body.appendChild(skipIntroButton);

    // Hide the button initially
    skipIntroButton.style.display = 'none';

    // Function to update button visibility
    const updateSkipIntroButton = () => {
        if (mediaPlayer.currentTime < introEndTime) {
            skipIntroButton.style.display = 'block';
        } else {
            skipIntroButton.style.display = 'none';
        }
    };

    // Check button visibility on load
    mediaPlayer.addEventListener('loaded-metadata', updateSkipIntroButton);

    // Play event to show button if intro hasn't ended
    mediaPlayer.addEventListener('play', () => {
        if (mediaPlayer.currentTime < introEndTime) {
            skipIntroButton.style.display = 'block';

            const timeRemaining = (introEndTime - mediaPlayer.currentTime) * 1000;
            setTimeout(() => {
                console.log('Hiding Skip Intro Button');
                skipIntroButton.style.display = 'none';
            }, timeRemaining);
        }
    });

    // Skip intro action
    skipIntroButton.addEventListener('click', () => {
        mediaPlayer.currentTime = introEndTime;
        skipIntroButton.style.display = 'none';
    });

    // Continuously hide button after intro time has passed
    mediaPlayer.addEventListener('time-change', updateSkipIntroButton);
});
</script>



<script>
        // Disable right-click context menu
        document.addEventListener('contextmenu', event => event.preventDefault());

        

        // Implement HLS/DASH or tokenized URL via backend
</script>
<script type="module" src="https://cdn.jsdelivr.net/npm/vidstack/dist/cdn/prod.js"></script>
</body>
</html>
